
// derive and create a new usermessage.
local CMessage	=	OOP_Derive( CUserMessage );

// constructor
function CMessage:__ctor( )
	// hook
	self:HookMessage( "CloneConfig" );

end

// handler
function CMessage:OnCloneConfig( msg )
	// read the config.
	local key = msg:ReadString();
	local type = msg:ReadString();
	local value = msg:ReadString();
	
	// store
	if( type == "number" ) then
		VMFSuite.Config[ key ] = tonumber( value );
		
	elseif( type == "boolean" ) then
		VMFSuite.Config[ key ] = util.tobool( value );
	
	else
		VMFSuite.Config[ key ] = value;
		
	end
	
	// debug
	if( VMFSuite.Debug ) then
		print( "Replicating server setting [" .. key .. "][" .. value .. "]" );
		
	end
end

// create
local msg = CMessage:create();
